{********************************************
; File: Quickdraw.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT QUICKDRAW;
INTERFACE
USES TYPES;
CONST

{ Error Codes }
alreadyInitialized = $0401;  { Quickdraw already initialized }
cannotReset = $0402;  { never used }
notInitialized = $0403;  { Quickdraw not initialized }
screenReserved = $0410;  { screen reserved }
badRect = $0411;  { bad rectangle }
notEqualChunkiness = $0420;  { Chunkiness is not equal }
rgnAlreadyOpen = $0430;  { region is already open }
rgnNotOpen = $0431;  { region is not open }
rgnScanOverflow = $0432;  { region scan overflow }
rgnFull = $0433;  { region is full }
polyAlreadyOpen = $0440;  { poly is already open }
polyNotOpen = $0441;  { poly is not open }
polyTooBig = $0442;  { poly is too big }
badTableNum = $0450;  { bad table number }
badColorNum = $0451;  { bad color number }
badScanLine = $0452;  { bad scan line }
notImplemented = $04FF;  { not implemented }

{  }
tsNumber = $04;

{ AnSCBByte Masks }
_colorTable = $0F;  { Mask for SCB color table }
scbReserved = $10;  { Mask for SCB reserved bit }
scbFill = $20;  { Mask for SCB fill bit }
scbInterrupt = $40;  { Mask for SCB interrupt bit }
scbColorMode = $80;  { Mask for SCB color mode bit }

{ ColorData }
table320 = $32;  { (val=size) }
table640 = $32;  { (val=size) }

{ ColorValue }
blueMask = $000F;  { Mask for Blue nibble }
greenMask = $00F0;  { Mask for green nibble }
redMask = $0F00;  { Mask for red nibble }

{ FontFlags }
widMaxSize = $0001;
zeroSize = $0002;

{ GrafPort Sizes }
maskSize = $08;  { Mask Size (val=size) }
locSize = $10;  { Loc Size (val=size) }
patsize = $20;  { Pattern Size (val=size) }
pnStateSize = $32;  { Pen State Size (Val=size) }
portSize = $AA;  { Size of GrafPort }

{ MasterColors }
black = $000;  { These work in 320 and 640 mode }
blue = $00F;  { These work in 320 and 640 mode }
darkGreen320 = $080;  { These work in 320 mode }
green320 = $0E0;  { These work in 320 mode }
green640 = $0F0;  { These work in 640 mode }
lightBlue320 = $4DF;  { These work in 320 mode }
purple320 = $72C;  { These work in 320 mode }
darkGray320 = $777;  { These work in 320 mode }
periwinkleBlue320 = $78F;  { These work in 320 mode }
brown320 = $841;  { These work in 320 mode }
lightGray320 = $0CCC;  { These work in 320 mode }
red320 = $0D00;  { These work in 320 mode }
lilac320 = $0DAF;  { These work in 320 mode }
red640 = $0F00;  { These work in 640 mode }
orange320 = $0F70;  { These work in 320 mode }
flesh320 = $0FA9;  { These work in 320 mode }
yellow = $0FF0;  { These work in 320 and 640 mode }
white = $0FFF;  { These work in 320 and 640 mode }

{ PenMode Data }
modeCopy = $0000;
modeOR = $0001;
modeXOR = $0002;
modeBIC = $0003;
modeForeCopy = $0004;
modeForeOR = $0005;
modeForeXOR = $0006;
modeForeBIC = $0007;
modeNOT = $8000;
notCopy = $8000;
notOR = $8001;
notXOR = $8002;
notBIC = $8003;
notForeCOPY = $8004;
notForeOR = $8005;
notForeXOR = $8006;
notForeBIC = $8007;

{ QDStartup }
mode320 = $0000;  { Argument to QDStartup }
mode640 = $0080;  { Argument to QDStartup }

{ TextStyle }
plainMask = $0000;  { Mask for plain text bit }
boldMask = $0001;  { Mask for bold bit }
italicMask = $0002;  { Mask for italic bit }
underlineMask = $0004;  { Mask for underline bit }
outlineMask = $0008;  { Mask for outline bit }
shadowMask = $0010;  { Mask for shadow bit }
fUseShadowing = $4000;
fFastPortAware = $4000;

TYPE
TextStyle = Integer ;
ColorValue = Integer ;
AnSCBByte = Byte ;
PatternPtr = ^Pattern;
Pattern = PACKED ARRAY[1..32] of Byte ;
Mask = PACKED ARRAY[1..8] OF Byte;
CursorHndl = ^CursorPtr;
CursorPtr = ^Cursor;
Cursor = RECORD
    cursorHeight : Integer; { size in bytes }
    cursorWidth : Integer; { enclosing rectangle }
    cursorData : ARRAY[1..1,1..1] OF Integer;
    cursorMask : ARRAY[1..1,1..1] OF Integer;
    cursorHotSpot : Point;
END;
RegionHndl = ^RegionPtr;
RegionPtr = ^Region;
Region = RECORD
    rgnSize : Integer; { size in bytes }
    rgnBBox : Rect; { enclosing rectangle }
END;
BufDimRecHndl = ^BufDimRecPtr;
BufDimRecPtr = ^BufDimRec;
BufDimRec = RECORD
    maxWidth : Integer;
    textBufHeight : Integer;
    textBufferWords : Integer;
    fontWidth : Integer;
END;
FontHndl = ^FontPtr;
FontPtr = ^Font;
Font = RECORD
    offseToMF : Integer; { fully defined front of the Font record. }
    family : Integer;
    style : TextStyle;
    size : Integer;
    version : Integer;
    fbrExtent : Integer;
    highowTLoc : Integer;
END;
FontGlobalsRecHndl = ^FontGlobalsRecPtr;
FontGlobalsRecPtr = ^FontGlobalsRecord;
FontGlobalsRecord = RECORD
    fgFontID : Integer; { currently 12 bytes long, but may be expanded }
    fgStyle : TextStyle;
    fgSize : Integer;
    fgVersion : Integer;
    fgWidMax : Integer;
    fgFBRExtent : Integer;
END;
FontIDHndl = ^FontIDPtr;
FontIDPtr = ^FontID;
FontID = PACKED RECORD
  CASE Integer OF
    0:
      (  famNum : Integer;
         fontStyle : Byte;
         fontSize : Byte;
      );
    1:
      (fidLong : Longint);
  END;

FontInfoRecHndl = ^FontInfoRecPtr;
FontInfoRecPtr = ^FontInfoRecord;
FontInfoRecord = RECORD
    ascent : Integer;
    descent : Integer;
    widMax : Integer;
    leading : Integer;
END;
LocInfoHndl = ^LocInfoPtr;
LocInfoPtr = ^LocInfo;
LocInfo = RECORD
    portSCB : Integer; { SCBByte in low byte }
    ptrToPixImage : Ptr; { ImageRef }
    width : Integer; { Width }
    boundsRect : Rect; { BoundsRect }
END;
QDProcsHndl = ^QDProcsPtr;
QDProcsPtr = ^QDProcs;
QDProcs = RECORD
    stdText : VoidProcPtr;
    stdLine : VoidProcPtr;
    stdRect : VoidProcPtr;
    stdRRect : VoidProcPtr;
    stdOval : VoidProcPtr;
    stdArc : VoidProcPtr;
    stdPoly : VoidProcPtr;
    stdRgn : VoidProcPtr;
    stdPixels : VoidProcPtr;
    stdComment : VoidProcPtr;
    stdTxMeas : VoidProcPtr;
    stdTxBnds : VoidProcPtr;
    stdGetPic : VoidProcPtr;
    stdPutPic : VoidProcPtr;
END;
GrafPortHndl = ^GrafPortPtr;
GrafPortPtr = ^GrafPort;
GrafPort = RECORD
    portInfo : LocInfo;
    portRect : Rect; { PortRect }
    clipRgn : RegionHndl; { Clip Rgn. Pointer }
    visRgn : RegionHndl; { Vis. Rgn. Pointer }
    bkPat : Pattern; { BackGround Pattern }
    pnLoc : Point; { Pen Location }
    pnSize : Point; { Pen Size }
    pnMode : Integer; { Pen Mode }
    pnPat : Pattern; { Pen Pattern }
    pnMask : Mask; { Pen Mask }
    pnVis : Integer; { Pen Visable }
    fontHandle : FontHndl;
    fontID : FontID; { Font ID }
    fontFlags : Integer; { FontFlags }
    txSize : Integer; { Text Size }
    txFace : TextStyle; { Text Face }
    txMode : Integer; { Text Mode }
    spExtra : Fixed; { Fixed Point Value }
    chExtra : Fixed; { Fixed Point Value }
    fgColor : Integer; { ForeGround Color }
    bgColor : Integer; { BackGround Color }
    picSave : Handle; { PicSave }
    rgnSave : Handle; { RgnSave }
    polySave : Handle; { PolySave }
    grafProcs : QDProcsPtr;
    arcRot : Integer; { ArcRot }
    userField : Longint; { UserField }
    sysField : Longint; { SysField }
END;
PaintParamHndl = ^PaintParamPtr;
PaintParamPtr = ^PaintParam;
PaintParam = RECORD
    ptrToSourceLocInfo : LocInfoPtr;
    ptrToDestLocInfo : LocInfoPtr;
    ptrToSourceRect : RectPtr;
    ptrToDestPoint : PointPtr;
    mode : Integer;
    maskHandle : Handle; { clip region }
END;
PenStateHndl = ^PenStatePtr;
PenStatePtr = ^PenState;
PenState = RECORD
    psPenLoc : Point;
    psPenSize : Point;
    psPenMode : Integer;
    psPenPat : Pattern;
    psPenMask : Mask;
END;
RomFontRecHndl = ^RomFontRecPtr;
RomFontRecPtr = ^RomFontRec;
RomFontRec = RECORD
    rfFamNum : Integer;
    rfFamStyle : Integer;
    rfSize : Integer;
    rfFontHandle : FontHndl;
    rfNamePtr : Ptr;
    rfFBRExtent : Integer;
END;
ColorTableHndl = ^ColorTablePtr;
ColorTablePtr = ^ColorTable;
ColorTable = ARRAY [0..15] OF Integer ;
PROCEDURE AddPt (VAR srcPtPtr:Point;VAR destPtPtr:Point)  ;
PROCEDURE CStringBounds ( cStringPtr:Ptr;VAR resultRect:Rect)  ;
FUNCTION CStringWidth ( cStringPtr:Ptr) : Integer ;
PROCEDURE CharBounds ( theChar:CHAR;VAR resultPtr:Rect)  ;
FUNCTION CharWidth ( theChar:CHAR) : Integer ;
PROCEDURE ClearScreen ( colorWord:Integer)  ;
PROCEDURE ClipRect ( rectPtr:Rect)  ;
PROCEDURE ClosePoly   ;
PROCEDURE ClosePort ( portPtr:GrafPortPtr)  ;
PROCEDURE CloseRgn ( aRgnHandle:RegionHndl)  ;
PROCEDURE CopyRgn ( srcRgnHandle:RegionHndl; destRgnHandle:RegionHndl)  ;
PROCEDURE DiffRgn ( rgn1Handle:RegionHndl; rgn2Handle:RegionHndl; diffRgnHandle:RegionHndl)  ;
PROCEDURE DisposeRgn ( aRgnHandle:RegionHndl)  ;
PROCEDURE DrawCString ( cStrPtr:CStringPtr)  ;
PROCEDURE DrawChar ( theChar:CHAR)  ;
PROCEDURE DrawString ( str:Str255)  ;
PROCEDURE DrawText ( textPtr:Ptr; textLength:Integer)  ;
FUNCTION  EmptyRgn ( aRgnHandle:RegionHndl) : Boolean ;
FUNCTION EqualPt (VAR point1Ptr:Point;VAR point2Ptr:Point) : Boolean ;
FUNCTION EqualRect ( rect1Ptr:Rect; rect2Ptr:Rect) : Boolean ;
FUNCTION  EqualRgn ( rgn1Handle:RegionHndl; rgn2Handle:RegionHndl) : Boolean ;
PROCEDURE EraseArc ( rectPtr:Rect; startAngle:Integer; arcAngle:Integer)  ;
PROCEDURE EraseOval ( rectPtr:Rect)  ;
PROCEDURE ErasePoly ( polyHandle:Handle)  ;
PROCEDURE EraseRRect ( rectPtr:Rect; ovalWidth:Integer; ovalHeight:Integer)  ;
PROCEDURE EraseRect ( rectPtr:Rect)  ;
PROCEDURE EraseRgn ( aRgnHandle:RegionHndl)  ;
PROCEDURE FillArc ( rectPtr:Rect; startAngle:Integer; arcAngle:Integer; patternPtr:Pattern)  ;
PROCEDURE FillOval ( rectPtr:Rect; patternPtr:Pattern)  ;
PROCEDURE FillPoly ( polyHandle:Handle; patternPtr:Pattern)  ;
PROCEDURE FillRRect ( rectPtr:Rect; ovalWidth:Integer; ovalHeight:Integer; patternPtr:Pattern)  ;
PROCEDURE FillRect ( rectPtr:Rect; patternPtr:Pattern)  ;
PROCEDURE FillRgn ( aRgnHandle:RegionHndl; __patternPtr:Pattern)  ;
PROCEDURE ForceBufDims ( maxWidth:Integer; maxFontHeight:Integer; maxFBRExtent:Integer)  ;
PROCEDURE FrameArc ( rectPtr:Rect; startAngle:Integer; arcAngle:Integer)  ;
PROCEDURE FrameOval ( rectPtr:Rect)  ;
PROCEDURE FramePoly ( polyHandle:Handle)  ;
PROCEDURE FrameRRect ( rectPtr:Rect; ovalWidth:Integer; ovalHeight:Integer)  ;
PROCEDURE FrameRect ( rectPtr:Rect)  ;
PROCEDURE FrameRgn ( aRgnHandle:RegionHndl)  ;
FUNCTION GetAddress ( tableID:Integer) : Ptr ;
FUNCTION GetArcRot  : Integer ;
FUNCTION GetBackColor  : Integer ;
PROCEDURE GetBackPat (VAR patternPtr:Pattern)  ;
FUNCTION GetCharExtra  : Fixed ;
PROCEDURE GetClip ( aRgnHandle:RegionHndl)  ;
FUNCTION  GetClipHandle  : RegionHndl ;
FUNCTION GetColorEntry ( tableNumber:Integer; entryNumber:Integer) : Integer ;
PROCEDURE GetColorTable ( tableNumber:Integer;VAR destTablePtr:ColorTable)  ;
FUNCTION GetCursorAdr  : CursorPtr ;
FUNCTION GetFGSize  : Integer ;
FUNCTION GetFont  : FontHndl ;
FUNCTION GetFontFlags  : Integer ;
PROCEDURE GetFontGlobals (VAR fgRecPtr:FontGlobalsRecord)  ;
FUNCTION  GetFontID  : FontID ;
PROCEDURE GetFontInfo (VAR fontInfoRecPtr:FontInfoRecord)  ;
FUNCTION GetFontLore (VAR recordPtr:FontGlobalsRecord; recordSize:Integer) : Integer ;
FUNCTION GetForeColor  : Integer ;
FUNCTION GetGrafProcs  : QDProcsPtr ;
FUNCTION GetMasterSCB  : Integer ;
PROCEDURE GetPen (VAR pointPtr:Point)  ;
PROCEDURE GetPenMask (VAR maskPtr:Mask)  ;
FUNCTION GetPenMode  : Integer ;
PROCEDURE GetPenPat (VAR patternPtr:Pattern)  ;
PROCEDURE GetPenSize (VAR pointPtr:Point)  ;
PROCEDURE GetPenState (VAR aPenStatePtr:PenState)  ;
FUNCTION GetPicSave  : Longint ;
FUNCTION GetPixel ( h:Integer; v:Integer) : Integer ;
FUNCTION GetPolySave  : Longint ;
FUNCTION GetPort  : GrafPortPtr ;
PROCEDURE GetPortLoc (VAR locInfoPtr:LocInfo)  ;
PROCEDURE GetPortRect (VAR portRectPtr:Rect)  ;
PROCEDURE GetROMFont (VAR recordPtr:RomFontRec)  ;
FUNCTION GetRgnSave  : Longint ;
FUNCTION GetSCB ( scanLine:Integer) : Integer ;
FUNCTION GetSpaceExtra  : Fixed ;
FUNCTION GetStandardSCB  : Integer ;
FUNCTION GetSysField  : Longint ;
FUNCTION GetSysFont  : FontHndl ;
FUNCTION GetTextFace  : TextStyle ;
FUNCTION GetTextMode  : Integer ;
FUNCTION GetTextSize  : Integer ;
FUNCTION GetUserField  : Longint ;
FUNCTION  GetVisHandle  : RegionHndl ;
PROCEDURE GetVisRgn ( aRgnHandle:RegionHndl)  ;
PROCEDURE GlobalToLocal (VAR pointPtr:Point)  ;
PROCEDURE GrafOff   ;
PROCEDURE GrafOn   ;
PROCEDURE HideCursor   ;
PROCEDURE HidePen   ;
PROCEDURE InflateTextBuffer ( newWidth:Integer; newHeight:Integer)  ;
PROCEDURE InitColorTable (VAR tablePtr:ColorTable)  ;
PROCEDURE InitCursor   ;
PROCEDURE InitPort ( portPtr:GrafPortPtr)  ;
PROCEDURE InsetRect (VAR insetRectPtr:Rect; deltaH:Integer; deltaV:Integer)  ;
PROCEDURE InsetRgn ( aRgnHandle:RegionHndl; dH:Integer; dV:Integer)  ;
PROCEDURE InvertArc ( rectPtr:Rect; startAngle:Integer; arcAngle:Integer)  ;
PROCEDURE InvertOval ( rectPtr:Rect)  ;
PROCEDURE InvertPoly ( polyHandle:Handle)  ;
PROCEDURE InvertRRect ( rectPtr:Rect; ovalWidth:Integer; ovalHeight:Integer)  ;
PROCEDURE InvertRect ( rectPtr:Rect)  ;
PROCEDURE InvertRgn ( aRgnHandle:RegionHndl)  ;
PROCEDURE KillPoly ( polyHandle:Handle)  ;
PROCEDURE Line ( dH:Integer; dV:Integer)  ;
PROCEDURE LineTo ( h:Integer; v:Integer)  ;
PROCEDURE LocalToGlobal (VAR pointPtr:Point)  ;
PROCEDURE MapPoly ( polyHandle:Handle; srcRectPtr:Rect; destRectPtr:Rect)  ;
PROCEDURE MapPt (VAR pointPtr:Point; srcRectPtr:Rect; destRectPtr:Rect)  ;
PROCEDURE MapRect (VAR rectPtr:Rect; srcRectPtr:Rect; destRectPtr:Rect)  ;
PROCEDURE MapRgn ( aRgnHandle:RegionHndl; srcRectPtr:Rect; destdRectPtr:Rect)  ;
PROCEDURE Move ( dH:Integer; dV:Integer)  ;
PROCEDURE MovePortTo ( h:Integer; v:Integer)  ;
PROCEDURE MoveTo ( h:Integer; v:Integer)  ;
FUNCTION  NewRgn  : RegionHndl ;
FUNCTION NotEmptyRect ( rectPtr:Rect) : Boolean ;
PROCEDURE ObscureCursor   ;
PROCEDURE OffsetPoly ( polyHandle:Handle; dH:Integer; dV:Integer)  ;
PROCEDURE OffsetRect (VAR offsetRectPtr:Rect; deltaH:Integer; deltaV:Integer)  ;
PROCEDURE OffsetRgn ( aRgnHandle:RegionHndl; dH:Integer; dV:Integer)  ;
FUNCTION OpenPoly  : handle ;
PROCEDURE OpenPort ( portPtr:GrafPortPtr)  ;
PROCEDURE OpenRgn   ;
PROCEDURE PPToPort ( srcLocPtr:LocInfoPtr; srcRectPtr:Rect; destX:Integer; destY:Integer; transferMode:Integer)  ;
PROCEDURE PaintArc ( rectPtr:Rect; startAngle:Integer; arcAngle:Integer)  ;
PROCEDURE PaintOval ( rectPtr:Rect)  ;
PROCEDURE PaintPixels ( aPaintParamPtr:PaintParam)  ;
PROCEDURE PaintPoly ( polyHandle:Handle)  ;
PROCEDURE PaintRRect ( rectPtr:Rect; ovalWidth:Integer; ovalHeight:Integer)  ;
PROCEDURE PaintRect ( rectPtr:Rect)  ;
PROCEDURE PaintRgn ( aRgnHandle:RegionHndl)  ;
PROCEDURE PenNormal   ;
PROCEDURE Pt2Rect (VAR point1Ptr:PointPtr;VAR point2Ptr:PointPtr;VAR toRectPtr:Rect)  ;
FUNCTION PtInRect (VAR pointPtr:Point; rectPtr:Rect) : Boolean ;
FUNCTION  PtInRgn (VAR aPointPtr:PointPtr; aRgnHandle:RegionHndl) : Boolean ;
PROCEDURE QDBootInit   ;
PROCEDURE QDReset   ;
PROCEDURE QDShutDown   ;
PROCEDURE QDStartUp ( dPageAddr:Integer; masterSCB:Integer; maxWidth:Integer; userID:Integer)  ;
FUNCTION QDStatus  : Boolean ;
FUNCTION QDVersion  : Integer ;
FUNCTION Random  : Integer ;
FUNCTION  RectInRgn ( aRectPtr:Rect; aRgnHandle:RegionHndl) : Boolean ;
PROCEDURE RectRgn ( aRgnHandle:RegionHndl; __rectPtr:Rect)  ;
PROCEDURE RestoreBufDims ( sizeInfoPtr:BufDimRecPtr)  ;
PROCEDURE SaveBufDims (VAR sizeInfoPtr:BufDimRec)  ;
PROCEDURE ScalePt (VAR pointPtr:Point; srcRectPtr:Rect; destRectPtr:Rect)  ;
PROCEDURE ScrollRect ( __rectPtr:Rect; dH:Integer; dV:Integer; aRgnHandle:RegionHndl)  ;
FUNCTION SectRect ( rect1Ptr:Rect; rect2Ptr:Rect;VAR intersectRectPtr:Rect) : Boolean ;
PROCEDURE SectRgn ( rgn1Handle:RegionHndl; rgn2Handle:RegionHndl; destRgnHandle:RegionHndl)  ;
PROCEDURE SetAllSCBs ( newSCB:Integer)  ;
PROCEDURE SetArcRot ( arcRotValue:Integer)  ;
PROCEDURE SetBackColor ( backColor:Integer)  ;
PROCEDURE SetBackPat ( patternPtr:Pattern)  ;
PROCEDURE SetBufDims ( maxWidth:Integer; maxFontHeight:Integer; maxFBRExtent:Integer)  ;
PROCEDURE SetCharExtra ( charExtra:Fixed)  ;
PROCEDURE SetClip ( aRgnHandle:RegionHndl)  ;
PROCEDURE SetClipHandle ( aRgnHandle:RegionHndl)  ;
PROCEDURE SetColorEntry ( tableNumber:Integer; entryNumber:Integer; newColor:ColorValue)  ;
PROCEDURE SetColorTable ( tableNumber:Integer; srcTablePtr:ColorTable)  ;
PROCEDURE SetCursor ( theCursorPtr:Cursor)  ;
PROCEDURE SetEmptyRgn ( aRgnHandle:RegionHndl)  ;
PROCEDURE SetFont ( newFontHandle:FontHndl)  ;
PROCEDURE SetFontFlags ( fontFlags:Integer)  ;
PROCEDURE SetFontID ( newFontID:FontID)  ;
PROCEDURE SetForeColor ( foreColor:Integer)  ;
PROCEDURE SetGrafProcs ( grafProcsPtr:QDProcsPtr)  ;
PROCEDURE SetIntUse ( useInt:Boolean)  ;
PROCEDURE SetMasterSCB ( masterSCB:Integer)  ;
PROCEDURE SetOrigin ( h:Integer; v:Integer)  ;
PROCEDURE SetPenMask ( maskPtr:Mask)  ;
PROCEDURE SetPenMode ( penMode:Integer)  ;
PROCEDURE SetPenPat ( patternPtr:Pattern)  ;
PROCEDURE SetPenSize ( penWidth:Integer; penHeight:Integer)  ;
PROCEDURE SetPenState ( newPenStatePtr:PenState)  ;
PROCEDURE SetPicSave ( picSaveValue:Longint)  ;
PROCEDURE SetPolySave ( polySaveValue:Longint)  ;
PROCEDURE SetPort ( portPtr:GrafPortPtr)  ;
PROCEDURE SetPortLoc ( newLocInfoPtr:LocInfo)  ;
PROCEDURE SetPortRect ( rectPtr:Rect)  ;
PROCEDURE SetPortSize ( portWidth:Integer; portHeight:Integer)  ;
PROCEDURE SetPt (VAR srcPtPtr:Point; h:Integer; v:Integer)  ;
PROCEDURE SetRandSeed ( randomSeed:Longint)  ;
PROCEDURE SetRect (VAR aRectPtr:Rect; left:Integer; top:Integer; right:Integer; bottom:Integer)  ;
PROCEDURE SetRectRgn ( aRgnHandle:RegionHndl; left:Integer; top:Integer; right:Integer; bottom:Integer)  ;
PROCEDURE SetRgnSave ( rgnSaveValue:Longint)  ;
PROCEDURE SetSCB ( scanLine:Integer; newSCB:Integer)  ;
PROCEDURE SetSolidBackPat ( colorNum:Integer)  ;
PROCEDURE SetSolidPenPat ( colorNum:Integer)  ;
PROCEDURE SetSpaceExtra ( spaceExtra:Fixed)  ;
PROCEDURE SetStdProcs ( stdProcRecPtr:QDProcsPtr)  ;
PROCEDURE SetSysField ( sysFieldValue:Longint)  ;
PROCEDURE SetSysFont ( fontHandle:FontHndl)  ;
PROCEDURE SetTextFace ( textFace:TextStyle)  ;
PROCEDURE SetTextMode ( textMode:Integer)  ;
PROCEDURE SetTextSize ( textSize:Integer)  ;
PROCEDURE SetUserField ( userFieldValue:Longint)  ;
PROCEDURE SetVisHandle ( aRgnHandle:RegionHndl)  ;
PROCEDURE SetVisRgn ( aRgnHandle:RegionHndl)  ;
PROCEDURE ShowCursor   ;
PROCEDURE ShowPen   ;
PROCEDURE SolidPattern ( colorNum:Integer;VAR patternPtr:Pattern)  ;
PROCEDURE StringBounds ( str:Str255;VAR resultPtr:Rect)  ;
FUNCTION StringWidth ( str:Str255) : Integer ;
PROCEDURE SubPt (VAR srcPtPtr:Point;VAR destPtPtr:Point)  ;
PROCEDURE TextBounds ( textPtr:Ptr; textLength:Integer;VAR resultPtr:Rect)  ;
FUNCTION TextWidth ( textPtr:Ptr; textLength:Integer) : Integer ;
PROCEDURE UnionRect ( rect1Ptr:Rect; rect2Ptr:Rect;VAR unionRectPtr:Rect)  ;
PROCEDURE UnionRgn ( rgn1Handle:RegionHndl; rgn2Handle:RegionHndl; unionRgnHandle:RegionHndl)  ;
PROCEDURE XorRgn ( rgn1Handle:RegionHndl; rgn2Handle:RegionHndl; xorRgnHandle:RegionHndl)  ;
IMPLEMENTATION
END.
